#Palaeozoic jaw disparity project
##Written in R version 4.3.3 (2024-02-29 ucrt) -- "Angel Food Cake"

setwd("D:/Jaw_disparity_project/Jaw_disparity/SUPPLEMENTARY FILE 7 Code_R2/Code shape occlusal")

# Install the remotes package if you haven't already installed it
#install.packages("remotes")

# Load the remotes package
#library(remotes)

library(Momocs)
library(jpeg)
library(ggplot2)
library(calibrate)
library(zoo)
library(e1071)
library(fBasics)
library(paleotree)
library(plotrix)
library(foreach)
library(svMisc)
library(doParallel)
library(parallel) 
library(ggplot2)
library(vegan)
library(dispRity)
library(xlsx)
library(car)
library(epm)

source("functions.txt")  #Necessary to run SoV later, this is the sum of variances function from Hughes et al 2013 PNAS

#Prepare Jaw figures####

#Import jaws to R
main_directory <- getwd()
main_directory
# change directory to the folder where the jaw outlines are 
setwd("D:/Jaw_disparity_project/Jaw_disparity/SUPPLEMENTARY FILE 7 Code_R2/Code shape occlusal/Silhouette_occlusal")
jaw_directory <- getwd()
jaw_directory
####### Create a list of the files names for all the jaws in the directory
jpg.list <- list.files(jaw_directory, full.names=T)
jpg.list <- as.vector(jpg.list)
jpg.list <- Filter(function(x) !any(grepl("Thumbs", x)), jpg.list) # this is here to remove any file with the name Thumbs - in case loads in .thumbnail
jpg.list
#### Import the jaw images using MOMOCS package
alljaws <- import_jpg(jpg.list)
alljaws 
# return to the main directory where you would save results etc, now we have loaded jaws in
setwd(main_directory)

#Scale, centre and align jaw silhouettes
coo_jaws_final <- Out(alljaws) #Convert jaws into 'coo' object for outline analyses

stack(coo_jaws_final)
panel(coo_jaws_final, col="grey75", border="black")

coo_jaws_final_cent <- coo_scale(coo_center(coo_jaws_final)) #Centre all the jaws and scale the coordinates
stack(coo_jaws_final_cent)

coo_jaws_final_cent_align <- coo_alignxax(coo_jaws_final_cent) #Align all the shapes along the x-axis

stack(coo_jaws_final_cent_align)
panel(coo_jaws_final_cent_align, col="grey75", border="black")

coo_jaws_final_cent_align_slid <- coo_slidedirection(coo_jaws_final_cent_align, center=F, direction='S')

stack(coo_jaws_final_cent_align_slid)

#Define number of points for the outlines and resample, finish by closing the outline
npoints <- 550
final_outline_coords <- coo_sample(coo_jaws_final_cent_align_slid, npoints)
is_closed(final_outline_coords)
final_outline_coords <- coo_close(final_outline_coords)
is_closed(final_outline_coords)
final_outline_coords

stack(final_outline_coords)
panel(final_outline_coords, col="grey75", border="black")

#Calibrate the number of harmonics required to account for shape variation
number_harmonics <- calibrate_harmonicpower(final_outline_coords, plot=T, nb.h=(npoints/2-1), "efourier")
harm99 <- number_harmonics$minh["99%"]
harm99_9 <- number_harmonics$minh["99.9%"]

# Visualise how each harmonic more closely approximates the actual shape; picks example jaw at random
dev.new() 
calibrate_reconstructions(final_outline_coords, "efourier", range=c(1:harm99))

efour_jaws_out <- efourier(final_outline_coords, nb.h=number_harmonics$minh["99%"], norm = FALSE)

write.xlsx(efour_jaws_out$coe, "EFA_output_occlusal.xlsx")

#Prepare for PCA 
pca_jaws_out <- PCA(efour_jaws_out, scale.=FALSE, center=TRUE)
pca_scores_shapes <- pca_jaws_out$x

#Visualisation
par(oma=c(0.5, 0.5, 0.5, 0.5))
plot(pca_jaws_out, cex=1, pch=19, bg="gray98")

pca_jaws_out #percentage of variance per PC axis

scree_results <- scree(pca_jaws_out, nax = 1:number_harmonics$minh["99%"])
plot(as.matrix(scree_results[,2]*100), type="l", xlab="Ordination axis", ylab="Percentage variance")
write.xlsx(scree_results, "scree_results_occlusal.xlsx") #save axes

propvar <- as.matrix(scree_results[,2])
greater_than_1_percent <- propvar [which(propvar>0.01),]
length(greater_than_1_percent)

PCcontrib(pca_jaws_out, nax = 1:length(greater_than_1_percent), sd.r = c(-3, -2, -1, -0.5, 0, 0.5, 1, 2, 3)) #Visualisation of shape variation per axis (all axes that explain >1% of variance)

#PC plots#####

pca_scores <- as.data.frame(pca_scores_shapes)
write.xlsx(pca_scores, "PCA_scores_occlusal.xlsx")

#(H1 = Hypothesis 1. H1-4 refer to the phylogenetic hypotheses concerning Amniota that are discussed in the main text.)

#Prepare amniote vs. non-amniote
group_data <- read.table("occ_group_amniote_h1.txt", row.names=1, header=T)
pca_scores$H1_A <- as.factor(group_data[,1])
group_data <- read.table("occ_group_amniote_h2.txt", row.names=1, header=T)
pca_scores$H2_A <- as.factor(group_data[,1])
group_data <- read.table("occ_group_amniote_h3.txt", row.names=1, header=T)
pca_scores$H3_A <- as.factor(group_data[,1])
group_data <- read.table("occ_group_amniote_h4.txt", row.names=1, header=T)
pca_scores$H4_A <- as.factor(group_data[,1])

#Prepare SynSaur
group_data <- read.table("occ_group_synsaur_h1.txt", row.names=1, header=T)
pca_scores$H1_SynSaur <- as.factor(group_data[,1])
group_data <- read.table("occ_group_synsaur_h2.txt", row.names=1, header=T)
pca_scores$H2_SynSaur <- as.factor(group_data[,1])
group_data <- read.table("occ_group_synsaur_h3.txt", row.names=1, header=T)
pca_scores$H3_SynSaur <- as.factor(group_data[,1])
group_data <- read.table("occ_group_synsaur_h4.txt", row.names=1, header=T)
pca_scores$H4_SynSaur <- as.factor(group_data[,1])

#Prepare herbivores vs. non-herbivores
group_data <- read.table("occ_group_herb.txt", row.names=1, header=T)
pca_scores$Herb <- as.factor(group_data[,1])

dev.off()
dev.new()
par(mfrow=c(2,2),pin = c(4, 3))

#Amniote vs. non-amniote
plot(x=pca_scores$PC1,y=pca_scores$PC2, 
     pch=c(22,21) [as.numeric(as.factor(pca_scores$H1_A))], cex=1.5,
     bg=c('darkgoldenrod','lightgoldenrod') [as.numeric(as.factor(pca_scores$H1_A))],
     xlab = ('PC1 (43.33%)'),
     ylab = ('PC2 (21.01%)')
)
abline(h = 0, col = rgb(0.5, 0.5, 0.5, 0.5), lty = 2, lwd = 1)
abline(v = 0, col = rgb(0.5, 0.5, 0.5, 0.5), lty = 2, lwd = 1)
legend('topleft',pt.bg=c('darkgoldenrod', 'lightgoldenrod'),pch=21,pt.cex=0.8,bty='n',
       legend=levels(as.factor(pca_scores$H1_A)),ncol=1 )

plot(x=pca_scores$PC1,y=pca_scores$PC2, 
     pch=c(22,21) [as.numeric(as.factor(pca_scores$H2_A))], cex=1.5,
     bg=c('darkgoldenrod','lightgoldenrod') [as.numeric(as.factor(pca_scores$H2_A))],
     xlab = ('PC1 (43.33%)'),
     ylab = ('PC2 (21.01%)')
)
abline(h = 0, col = rgb(0.5, 0.5, 0.5, 0.5), lty = 2, lwd = 1)
abline(v = 0, col = rgb(0.5, 0.5, 0.5, 0.5), lty = 2, lwd = 1)
legend('topleft',pt.bg=c('darkgoldenrod', 'lightgoldenrod'),pch=21,pt.cex=0.8,bty='n',
       legend=levels(as.factor(pca_scores$H2_A)),ncol=1 )

plot(x=pca_scores$PC1,y=pca_scores$PC2, 
     pch=c(22,21) [as.numeric(as.factor(pca_scores$H3_A))], cex=1.5,
     bg=c('darkgoldenrod','lightgoldenrod') [as.numeric(as.factor(pca_scores$H3_A))],
     xlab = ('PC1 (43.33%)'),
     ylab = ('PC2 (21.01%)')
)
abline(h = 0, col = rgb(0.5, 0.5, 0.5, 0.5), lty = 2, lwd = 1)
abline(v = 0, col = rgb(0.5, 0.5, 0.5, 0.5), lty = 2, lwd = 1)
legend('topleft',pt.bg=c('darkgoldenrod', 'lightgoldenrod'),pch=21,pt.cex=0.8,bty='n',
       legend=levels(as.factor(pca_scores$H3_A)),ncol=1 )

plot(x=pca_scores$PC1,y=pca_scores$PC2, 
     pch=c(22,21) [as.numeric(as.factor(pca_scores$H4_A))], cex=1.5,
     bg=c('darkgoldenrod','lightgoldenrod') [as.numeric(as.factor(pca_scores$H4_A))],
     xlab = ('PC1 (43.33%)'),
     ylab = ('PC2 (21.01%)')
)
abline(h = 0, col = rgb(0.5, 0.5, 0.5, 0.5), lty = 2, lwd = 1)
abline(v = 0, col = rgb(0.5, 0.5, 0.5, 0.5), lty = 2, lwd = 1)
legend('topleft',pt.bg=c('darkgoldenrod', 'lightgoldenrod'),pch=21,pt.cex=0.8,bty='n',
       legend=levels(as.factor(pca_scores$H4_A)),ncol=1 )

#SynSaur
plot(x=pca_scores$PC1,y=pca_scores$PC2, 
     pch=c(21,22,22) [as.numeric(as.factor(pca_scores$H1_SynSaur))], cex=1.5,
     bg=c('lightgoldenrod','chartreuse','deepskyblue') [as.numeric(as.factor(pca_scores$H1_SynSaur))],
     xlab = ('PC1 (43.33%)'),
     ylab = ('PC2 (21.01%)')
)
abline(h = 0, col = rgb(0.5, 0.5, 0.5, 0.5), lty = 2, lwd = 1)
abline(v = 0, col = rgb(0.5, 0.5, 0.5, 0.5), lty = 2, lwd = 1)
legend('topleft',pt.bg=c('lightgoldenrod','chartreuse','deepskyblue'),pch=21,pt.cex=0.8,bty='n',
       legend=levels(as.factor(pca_scores$H1_SynSaur)),ncol=1 )

plot(x=pca_scores$PC1,y=pca_scores$PC2, 
     pch=c(21,22,22) [as.numeric(as.factor(pca_scores$H2_SynSaur))], cex=1.5,
     bg=c('lightgoldenrod','chartreuse','deepskyblue') [as.numeric(as.factor(pca_scores$H2_SynSaur))],
     xlab = ('PC1 (43.33%)'),
     ylab = ('PC2 (21.01%)')
)
abline(h = 0, col = rgb(0.5, 0.5, 0.5, 0.5), lty = 2, lwd = 1)
abline(v = 0, col = rgb(0.5, 0.5, 0.5, 0.5), lty = 2, lwd = 1)
legend('topleft',pt.bg=c('lightgoldenrod','chartreuse','deepskyblue'),pch=21,pt.cex=0.8,bty='n',
       legend=levels(as.factor(pca_scores$H2_SynSaur)),ncol=1 )

plot(x=pca_scores$PC1,y=pca_scores$PC2, 
     pch=c(21,22,22) [as.numeric(as.factor(pca_scores$H3_SynSaur))], cex=1.5,
     bg=c('lightgoldenrod','chartreuse','deepskyblue') [as.numeric(as.factor(pca_scores$H3_SynSaur))],
     xlab = ('PC1 (43.33%)'),
     ylab = ('PC2 (21.01%)')
)
abline(h = 0, col = rgb(0.5, 0.5, 0.5, 0.5), lty = 2, lwd = 1)
abline(v = 0, col = rgb(0.5, 0.5, 0.5, 0.5), lty = 2, lwd = 1)
legend('topleft',pt.bg=c('lightgoldenrod','chartreuse','deepskyblue'),pch=21,pt.cex=0.8,bty='n',
       legend=levels(as.factor(pca_scores$H3_SynSaur)),ncol=1 )

plot(x=pca_scores$PC1,y=pca_scores$PC2, 
     pch=c(21,22,22) [as.numeric(as.factor(pca_scores$H4_SynSaur))], cex=1.5,
     bg=c('lightgoldenrod','chartreuse','deepskyblue') [as.numeric(as.factor(pca_scores$H4_SynSaur))],
     xlab = ('PC1 (43.33%)'),
     ylab = ('PC2 (21.01%)')
)
abline(h = 0, col = rgb(0.5, 0.5, 0.5, 0.5), lty = 2, lwd = 1)
abline(v = 0, col = rgb(0.5, 0.5, 0.5, 0.5), lty = 2, lwd = 1)
legend('topleft',pt.bg=c('lightgoldenrod','chartreuse','deepskyblue'),pch=21,pt.cex=0.8,bty='n',
       legend=levels(as.factor(pca_scores$H4_SynSaur)),ncol=1 )

#Herb
plot(x=pca_scores$PC1,y=pca_scores$PC2, 
     pch=c(22,21) [as.numeric(as.factor(pca_scores$Herb))], cex=1.5,
     bg=c('darkolivegreen','firebrick') [as.numeric(as.factor(pca_scores$Herb))],
     xlab = ('PC1 (43.33%)'),
     ylab = ('PC2 (21.01%)')
)
abline(h = 0, col = rgb(0.5, 0.5, 0.5, 0.5), lty = 2, lwd = 1)
abline(v = 0, col = rgb(0.5, 0.5, 0.5, 0.5), lty = 2, lwd = 1)
legend('topleft',pt.bg=c('darkolivegreen', 'firebrick'),pch=21,pt.cex=0.8,bty='n',
       legend=levels(as.factor(pca_scores$Herb)),ncol=1 )

#dispRity####

set.seed(25)

#Amniota

#H1
pca_scores <- as.data.frame(pca_scores_shapes)
group_data <- read.table("occ_group_amniote_h1.txt", row.names = 1, header = TRUE)
pca_scores$H1_A <- as.factor(group_data[,1])

Amniote1 <- lapply(sort(unique(pca_scores$H1_A)), function(x) rownames(pca_scores)[pca_scores$H1_A == x])
names(Amniote1) <- sort(unique(pca_scores$H1_A))
Amniote1 <- Amniote1[c('Amniote', 'Non-amniote')]
pca_scores <- pca_scores[,-41]

Amniote1_disparity <- custom.subsets(pca_scores,group = Amniote1)
Amniote1_disparity <- boot.matrix(Amniote1_disparity,bootstraps = 1000)
Amniote1_disparity <- dispRity(Amniote1_disparity,metric = c(sum,variances))

test.dispRity(Amniote1_disparity,test = wilcox.test,correction = 'bonferroni')

#H2
pca_scores <- as.data.frame(pca_scores_shapes)
group_data <- read.table("occ_group_amniote_h2.txt", row.names = 1, header = TRUE)
pca_scores$H2_A <- as.factor(group_data[,1])

Amniote2 <- lapply(sort(unique(pca_scores$H2_A)), function(x) rownames(pca_scores)[pca_scores$H2_A == x])
names(Amniote2) <- sort(unique(pca_scores$H2_A))
Amniote2 <- Amniote2[c('Amniote', 'Non-amniote')]
pca_scores <- pca_scores[,-41]

Amniote2_disparity <- custom.subsets(pca_scores,group = Amniote2)
Amniote2_disparity <- boot.matrix(Amniote2_disparity,bootstraps = 1000)
Amniote2_disparity <- dispRity(Amniote2_disparity,metric = c(sum,variances))

test.dispRity(Amniote2_disparity,test = wilcox.test,correction = 'bonferroni')

#H3
pca_scores <- as.data.frame(pca_scores_shapes)
group_data <- read.table("occ_group_amniote_h3.txt", row.names = 1, header = TRUE)
pca_scores$H3_A <- as.factor(group_data[,1])

Amniote3 <- lapply(sort(unique(pca_scores$H3_A)), function(x) rownames(pca_scores)[pca_scores$H3_A == x])
names(Amniote3) <- sort(unique(pca_scores$H3_A))
Amniote3 <- Amniote3[c('Amniote', 'Non-amniote')]
pca_scores <- pca_scores[,-41]

Amniote3_disparity <- custom.subsets(pca_scores,group = Amniote3)
Amniote3_disparity <- boot.matrix(Amniote3_disparity,bootstraps = 1000)
Amniote3_disparity <- dispRity(Amniote3_disparity,metric = c(sum,variances))

test.dispRity(Amniote3_disparity,test = wilcox.test,correction = 'bonferroni')

#H4
pca_scores <- as.data.frame(pca_scores_shapes)
group_data <- read.table("occ_group_amniote_h4.txt", row.names = 1, header = TRUE)
pca_scores$H4_A <- as.factor(group_data[,1])

Amniote4 <- lapply(sort(unique(pca_scores$H4_A)), function(x) rownames(pca_scores)[pca_scores$H4_A == x])
names(Amniote4) <- sort(unique(pca_scores$H4_A))
Amniote4 <- Amniote4[c('Amniote', 'Non-amniote')]
pca_scores <- pca_scores[,-41]

Amniote4_disparity <- custom.subsets(pca_scores,group = Amniote4)
Amniote4_disparity <- boot.matrix(Amniote4_disparity,bootstraps = 1000)
Amniote4_disparity <- dispRity(Amniote4_disparity,metric = c(sum,variances))

test.dispRity(Amniote4_disparity,test = wilcox.test,correction = 'bonferroni')

dev.off()
dev.new()
par(mfrow=c(2,2), pin = c(4, 3))

plot(Amniote1_disparity, col = c('darkgoldenrod','lightgoldenrod'))
plot(Amniote2_disparity, col = c('darkgoldenrod','lightgoldenrod'))
plot(Amniote3_disparity, col = c('darkgoldenrod','lightgoldenrod'))
plot(Amniote4_disparity, col = c('darkgoldenrod','lightgoldenrod'))

#SynSaur

set.seed(25)

#H1
pca_scores <- as.data.frame(pca_scores_shapes)
group_data <- read.table("occ_group_synsaur_h1.txt", row.names = 1, header = TRUE)
pca_scores$synsaur1 <- as.factor(group_data[,1])

synsaur1 <- lapply(sort(unique(pca_scores$synsaur1)), function(x) rownames(pca_scores)[pca_scores$synsaur1 == x])
names(synsaur1) <- sort(unique(pca_scores$synsaur1))
synsaur1 <- synsaur1[c('Non-amniote', 'Sauropsida', 'Synapsida')]
pca_scores <- pca_scores[,-41]

synsaur_disparity1 <- custom.subsets(pca_scores,group = synsaur1)
synsaur_disparity1 <- boot.matrix(synsaur_disparity1,bootstraps = 1000)
synsaur_disparity1 <- dispRity(synsaur_disparity1,metric = c(sum,variances))

test.dispRity(synsaur_disparity1,test = wilcox.test,correction = 'bonferroni')

#H2
pca_scores <- as.data.frame(pca_scores_shapes)
group_data <- read.table("occ_group_synsaur_h2.txt", row.names = 1, header = TRUE)
pca_scores$synsaur2 <- as.factor(group_data[,1])

synsaur2 <- lapply(sort(unique(pca_scores$synsaur2)), function(x) rownames(pca_scores)[pca_scores$synsaur2 == x])
names(synsaur2) <- sort(unique(pca_scores$synsaur2))
synsaur2 <- synsaur2[c('Non-amniote', 'Sauropsida', 'Synapsida')]
pca_scores <- pca_scores[,-41]

synsaur_disparity2 <- custom.subsets(pca_scores,group = synsaur2)
synsaur_disparity2 <- boot.matrix(synsaur_disparity2,bootstraps = 1000)
synsaur_disparity2 <- dispRity(synsaur_disparity2,metric = c(sum,variances))

test.dispRity(synsaur_disparity2,test = wilcox.test,correction = 'bonferroni')

#H3
pca_scores <- as.data.frame(pca_scores_shapes)
group_data <- read.table("occ_group_synsaur_h3.txt", row.names = 1, header = TRUE)
pca_scores$synsaur3 <- as.factor(group_data[,1])

synsaur3 <- lapply(sort(unique(pca_scores$synsaur3)), function(x) rownames(pca_scores)[pca_scores$synsaur3 == x])
names(synsaur3) <- sort(unique(pca_scores$synsaur3))
synsaur3 <- synsaur3[c('Non-amniote', 'Sauropsida', 'Synapsida')]
pca_scores <- pca_scores[,-41]

synsaur_disparity3 <- custom.subsets(pca_scores,group = synsaur3)
synsaur_disparity3 <- boot.matrix(synsaur_disparity3,bootstraps = 1000)
synsaur_disparity3 <- dispRity(synsaur_disparity3,metric = c(sum,variances))

test.dispRity(synsaur_disparity3,test = wilcox.test,correction = 'bonferroni')

#H4
pca_scores <- as.data.frame(pca_scores_shapes)
group_data <- read.table("occ_group_synsaur_h4.txt", row.names = 1, header = TRUE)
pca_scores$synsaur4 <- as.factor(group_data[,1])

synsaur4 <- lapply(sort(unique(pca_scores$synsaur4)), function(x) rownames(pca_scores)[pca_scores$synsaur4 == x])
names(synsaur4) <- sort(unique(pca_scores$synsaur4))
synsaur4 <- synsaur4[c('Non-amniote', 'Sauropsida', 'Synapsida')]
pca_scores <- pca_scores[,-41]

synsaur_disparity4 <- custom.subsets(pca_scores,group = synsaur4)
synsaur_disparity4 <- boot.matrix(synsaur_disparity4,bootstraps = 1000)
synsaur_disparity4 <- dispRity(synsaur_disparity4,metric = c(sum,variances))

test.dispRity(synsaur_disparity4,test = wilcox.test,correction = 'bonferroni')

plot(synsaur_disparity1, col = c('lightgoldenrod','chartreuse','deepskyblue'))
plot(synsaur_disparity2, col = c('lightgoldenrod','chartreuse','deepskyblue'))
plot(synsaur_disparity3, col = c('lightgoldenrod','chartreuse','deepskyblue'))
plot(synsaur_disparity4, col = c('lightgoldenrod','chartreuse','deepskyblue'))

#Herbivores vs. non-herbivores

set.seed(25)

pca_scores <- as.data.frame(pca_scores_shapes)
group_data <- read.table("occ_group_herb.txt", row.names = 1, header = TRUE)
pca_scores$herb <- as.factor(group_data[,1])

herb <- lapply(sort(unique(pca_scores$herb)), function(x) rownames(pca_scores)[pca_scores$herb == x])
names(herb) <- sort(unique(pca_scores$herb))
herb <- herb[c('Herbivore', 'Non-herbivore')]
pca_scores <- pca_scores[,-41]

Herb_disparity <- custom.subsets(pca_scores,group = herb)
Herb_disparity <- boot.matrix(Herb_disparity,bootstraps = 1000)
Herb_disparity <- dispRity(Herb_disparity,metric = c(sum,variances))

test.dispRity(Herb_disparity,test = wilcox.test,correction = 'bonferroni')

plot(Herb_disparity, col = c('darkolivegreen','firebrick'))

#Run PERMANOVA#####

set.seed(25)

#Amniotes vs. non-amniotes

#H1
group_data <- read.table("occ_group_amniote_h1.txt", row.names=1, header=T)

Amniotes <- row.names(group_data)[group_data[,1] == 'Amniote'] 
Nonamniotes <- row.names(group_data)[group_data[,1] == 'Non-amniote']

group_factors <- as.vector(group_data[,1])
names(group_factors) <- row.names(group_data)

PERMANOVA.results.outline <- pairwise.adonis(pca_scores_shapes, factors=group_factors, sim.method = 'euclidean', p.adjust.m ='bonferroni')
PERMANOVA.results.outline

#H2
group_data <- read.table("occ_group_amniote_h2.txt", row.names=1, header=T)

Amniotes <- row.names(group_data)[group_data[,1] == 'Amniote'] 
Nonamniotes <- row.names(group_data)[group_data[,1] == 'Non-amniote']

group_factors <- as.vector(group_data[,1])
names(group_factors) <- row.names(group_data)

PERMANOVA.results.outline <- pairwise.adonis(pca_scores_shapes, factors=group_factors, sim.method = 'euclidean', p.adjust.m ='bonferroni')
PERMANOVA.results.outline

#H3
group_data <- read.table("occ_group_amniote_h3.txt", row.names=1, header=T)

Amniotes <- row.names(group_data)[group_data[,1] == 'Amniote'] 
Nonamniotes <- row.names(group_data)[group_data[,1] == 'Non-amniote']

group_factors <- as.vector(group_data[,1])
names(group_factors) <- row.names(group_data)

PERMANOVA.results.outline <- pairwise.adonis(pca_scores_shapes, factors=group_factors, sim.method = 'euclidean', p.adjust.m ='bonferroni')
PERMANOVA.results.outline

#H4
group_data <- read.table("occ_group_amniote_h4.txt", row.names=1, header=T)

Amniotes <- row.names(group_data)[group_data[,1] == 'Amniote'] 
Nonamniotes <- row.names(group_data)[group_data[,1] == 'Non-amniote']

group_factors <- as.vector(group_data[,1])
names(group_factors) <- row.names(group_data)

PERMANOVA.results.outline <- pairwise.adonis(pca_scores_shapes, factors=group_factors, sim.method = 'euclidean', p.adjust.m ='bonferroni')
PERMANOVA.results.outline

#SynSaur

set.seed(25)

#H1
group_data <- read.table("occ_group_synsaur_h1.txt", row.names=1, header=T)

Nonamniotes <- row.names(group_data)[group_data[,1] == 'Non-amniote'] 
Sauropsids <- row.names(group_data)[group_data[,1] == 'Sauropsida']
Synapsids <- row.names(group_data)[group_data[,1] == 'Synapsida']

group_factors <- as.vector(group_data[,1])
names(group_factors) <- row.names(group_data)

PERMANOVA.results.outline <- pairwise.adonis(pca_scores_shapes, factors=group_factors, sim.method = 'euclidean', p.adjust.m ='bonferroni')
PERMANOVA.results.outline

#H2
group_data <- read.table("occ_group_synsaur_h2.txt", row.names=1, header=T)

Nonamniotes <- row.names(group_data)[group_data[,1] == 'Non-amniote'] 
Sauropsids <- row.names(group_data)[group_data[,1] == 'Sauropsida']
Synapsids <- row.names(group_data)[group_data[,1] == 'Synapsida']

group_factors <- as.vector(group_data[,1])
names(group_factors) <- row.names(group_data)

PERMANOVA.results.outline <- pairwise.adonis(pca_scores_shapes, factors=group_factors, sim.method = 'euclidean', p.adjust.m ='bonferroni')
PERMANOVA.results.outline

#H3
group_data <- read.table("occ_group_synsaur_h3.txt", row.names=1, header=T)

Nonamniotes <- row.names(group_data)[group_data[,1] == 'Non-amniote'] 
Sauropsids <- row.names(group_data)[group_data[,1] == 'Sauropsida']
Synapsids <- row.names(group_data)[group_data[,1] == 'Synapsida']

group_factors <- as.vector(group_data[,1])
names(group_factors) <- row.names(group_data)

PERMANOVA.results.outline <- pairwise.adonis(pca_scores_shapes, factors=group_factors, sim.method = 'euclidean', p.adjust.m ='bonferroni')
PERMANOVA.results.outline

#H4
group_data <- read.table("occ_group_synsaur_h4.txt", row.names=1, header=T)

Nonamniotes <- row.names(group_data)[group_data[,1] == 'Non-amniote'] 
Sauropsids <- row.names(group_data)[group_data[,1] == 'Sauropsida']
Synapsids <- row.names(group_data)[group_data[,1] == 'Synapsida']

group_factors <- as.vector(group_data[,1])
names(group_factors) <- row.names(group_data)

PERMANOVA.results.outline <- pairwise.adonis(pca_scores_shapes, factors=group_factors, sim.method = 'euclidean', p.adjust.m ='bonferroni')
PERMANOVA.results.outline

#Herbivores vs. non-herbivores

set.seed(25)

group_data <- read.table("occ_group_herb.txt", row.names=1, header=T)

Herbivores <- row.names(group_data)[group_data[,1] == 'Herbivore'] 
Nonherbivores <- row.names(group_data)[group_data[,1] == 'Non-herbivore']

group_factors <- as.vector(group_data[,1])
names(group_factors) <- row.names(group_data)

PERMANOVA.results.outline <- pairwise.adonis(pca_scores_shapes, factors=group_factors, sim.method = 'euclidean', p.adjust.m ='bonferroni')
PERMANOVA.results.outline 

#Faunivorous amniotes vs. non-amniote tetrapods

set.seed(25)

group_data <- read.table("occ_group_amniote_carn.txt", row.names=1, header=T)
Nonamniotes <- row.names(group_data)[group_data[,1] == 'Non-amniote']
Faunivorousamniotes <- row.names(group_data)[group_data[,1] == 'Amniote_carn']
Herbivorousamniotes <- row.names(group_data)[group_data[,1] == 'Amniote_herb']
group_factors <- as.vector(group_data[,1])
names(group_factors) <- row.names(group_data)
PERMANOVA.results <- pairwise.adonis(pca_scores_shapes, factors=group_factors, sim.method = 'euclidean', p.adjust.m ='bonferroni')
PERMANOVA.results

#Morphospace through time#####

pca_scores <- as.data.frame(pca_scores_shapes)
bin_ranges <- read.table("bin_ranges_series.txt", header=T, row.names=1)
taxon_ages <- read.table ("taxon_ages_occlusal.txt", row.names=1, header=T)
taxon_ages <- as.data.frame(taxon_ages[rownames(pca_scores_shapes),])
time.bins <- list()
for (i in 1:length(rownames(bin_ranges))) {time.bins[[i]] <- rownames(taxon_ages)[which(taxon_ages$FAD > bin_ranges[i,"min.age"] & taxon_ages$LAD < bin_ranges[i,"max.age"])]}
names(time.bins) <- rownames(bin_ranges)
bin_PA <-  matrix(0, nrow=nrow(pca_scores_shapes), ncol=length(time.bins)) 
rownames(bin_PA) <- rownames(pca_scores_shapes)

for(x in 1:length(time.bins)) {
  taxaInHere <- match(time.bins [[x]], rownames(bin_PA))
  bin_PA[taxaInHere, x] <- 1
}

#H1
time <- as.data.frame(bin_PA)
pca_scores_data <- cbind(pca_scores,time)
group_data <- read.table("occ_group_synsaur_H1.txt", row.names=1, header=T)
pca_scores$H1_synsaur <- as.factor(group_data[,1])

dev.off()
dev.new()
par(mfrow=c(5,1), pin = c(2, 1))

plot(pca_scores_data[,1:2], 
     pch=c(21,22,22) [as.numeric(as.factor(pca_scores$H1_synsaur))], 
     bg=c('lightgoldenrod','chartreuse','deepskyblue') [as.numeric(as.factor(pca_scores$H1_synsaur))],
     cex=ifelse(pca_scores_data$V5=='1',1.5,0),
)
abline(h = 0, col = rgb(0.5, 0.5, 0.5, 0.5), lty = 2, lwd = 1)
abline(v = 0, col = rgb(0.5, 0.5, 0.5, 0.5), lty = 2, lwd = 1)

plot(pca_scores_data[,1:2], 
     pch=c(21,22,22) [as.numeric(as.factor(pca_scores$H1_synsaur))], 
     bg=c('lightgoldenrod','chartreuse','deepskyblue') [as.numeric(as.factor(pca_scores$H1_synsaur))],
     cex=ifelse(pca_scores_data$V4=='1',1.5,0),
)
abline(h = 0, col = rgb(0.5, 0.5, 0.5, 0.5), lty = 2, lwd = 1)
abline(v = 0, col = rgb(0.5, 0.5, 0.5, 0.5), lty = 2, lwd = 1)


plot(pca_scores_data[,1:2], 
     pch=c(21,22,22) [as.numeric(as.factor(pca_scores$H1_synsaur))], 
     bg=c('lightgoldenrod','chartreuse','deepskyblue') [as.numeric(as.factor(pca_scores$H1_synsaur))],
     cex=ifelse(pca_scores_data$V3=='1',1.5,0),
)
abline(h = 0, col = rgb(0.5, 0.5, 0.5, 0.5), lty = 2, lwd = 1)
abline(v = 0, col = rgb(0.5, 0.5, 0.5, 0.5), lty = 2, lwd = 1)

plot(pca_scores_data[,1:2], 
     pch=c(21,22,22) [as.numeric(as.factor(pca_scores$H1_synsaur))], 
     bg=c('lightgoldenrod','chartreuse','deepskyblue') [as.numeric(as.factor(pca_scores$H1_synsaur))],
     cex=ifelse(pca_scores_data$V2=='1',1.5,0),
)
abline(h = 0, col = rgb(0.5, 0.5, 0.5, 0.5), lty = 2, lwd = 1)
abline(v = 0, col = rgb(0.5, 0.5, 0.5, 0.5), lty = 2, lwd = 1)

plot(pca_scores_data[,1:2], 
     pch=c(21,22,22) [as.numeric(as.factor(pca_scores$H1_synsaur))], 
     bg=c('lightgoldenrod','chartreuse','deepskyblue') [as.numeric(as.factor(pca_scores$H1_synsaur))],
     cex=ifelse(pca_scores_data$V1=='1',1.5,0),
)
abline(h = 0, col = rgb(0.5, 0.5, 0.5, 0.5), lty = 2, lwd = 1)
abline(v = 0, col = rgb(0.5, 0.5, 0.5, 0.5), lty = 2, lwd = 1)

#Disparity through time####
dev.off()
dev.new()

bin_ranges <- read.table("bin_ranges_series.txt", header=T, row.names=1)
bin_ranges
taxon_ages <- read.table ("taxon_ages_occlusal.txt", row.names=1, header=T)
taxon_ages

taxon_ages <- as.data.frame(taxon_ages[rownames(pca_scores_shapes),])
time.bins <- list()
for (i in 1:length(rownames(bin_ranges))) {time.bins[[i]] <- rownames(taxon_ages)[which(taxon_ages$FAD > bin_ranges[i,"min.age"] & taxon_ages$LAD < bin_ranges[i,"max.age"])]}
names(time.bins) <- rownames(bin_ranges)
time.bins

bin_PA <-  matrix(0, nrow=nrow(pca_scores_shapes), ncol=length(time.bins)) 
rownames(bin_PA) <- rownames(pca_scores_shapes)
bin_PA

for(x in 1:length(time.bins)) {
  taxaInHere <- match(time.bins [[x]], rownames(bin_PA))
  bin_PA[taxaInHere, x] <- 1
}

bin_PA #Useful overview of taxa per time bin

time.bins

sov_disparity <- DtT (pca_scores_shapes, bin_PA, 1000)

sov_results_mean <- sov_disparity$Variance[1,]
sov_results_lower <- c(sov_disparity$Variance[1,]- sov_disparity$Variance[2,])
sov_results_upper <- c(sov_disparity$Variance[1,] +sov_disparity$Variance[2,])

sov_results_final_time <- data.frame(sov_results_mean, sov_results_lower, sov_results_upper)
colnames(sov_results_final_time) <- c("mean","lower","upper")
rownames(sov_results_final_time) <- names(time.bins)
sov_results_final_time

results_plot <- sov_results_final_time

#Create limits which will denote the time bins
midpoints <- rowMeans(bin_ranges)
nbins <- nrow(bin_ranges)

# set-up the plotting area
layout (matrix (1:1, 2, 1))
upper.y <- 1.2 * max (results_plot [, "upper"])
lower.y <- 0.8 * min (results_plot [, "lower"])
upper.CI <- results_plot[, "upper"]
lower.CI <- results_plot [, "lower"]
x.limits <- c(max(bin_ranges), min(bin_ranges))
y.limits <- c(lower.y*1.1, upper.y*0.9 )

# plot empty graph with time bins
plot (midpoints, y = results_plot [, "mean"], xlim = x.limits, ylim = y.limits, col = "transparent", xlab = "age (Ma)", ylab = "Disparity (sum of variances)", cex=0.8)
# plot time slices as shaded area, this will have to be expanded upon if more time bins are added
polygon (c(358.9, 323.2, 323.2, 358.9), y = c(-1000, -1000, 3000, 3000), border = NA, col = rgb (0, 0, 0, 0.06))
polygon (c(298.9, 273.01, 273.01, 298.9), y = c(-1000, -1000, 3000, 3000), border = NA, col = rgb (0, 0, 0, 0.06))
polygon (c(259.51, 251.902,251.902, 259.51), y = c(-1000, -1000, 3000, 3000), border = NA, col = rgb (0, 0, 0, 0.06))

abline(v=251.9)
abline(v=358.9)

# plot data
nbins<-nrow(bin_ranges)
polygon (c(midpoints, midpoints [nbins:1]), y = c(lower.CI, upper.CI [nbins:1]), border = NA, col = "lightblue")
lines (midpoints, y = results_plot [, "mean"])
points (midpoints, results_plot [, "mean"], pch = 21, col = "black", bg = "white", cex=1.3, lwd=1.4)

#Number of specimens per time bin #####

bin_alphadiversity <- colSums(bin_PA)

layout (matrix (1:1, 2, 1))
upper.y <- 40
lower.y <- 0
x.limits <- c(max(bin_ranges), min(bin_ranges))
y.limits <- c(lower.y*1, upper.y*1)

# plot empty graph with time bins
plot (midpoints, y = results_plot [, "mean"], xlim = x.limits, ylim = y.limits, col = "transparent", xlab = "age (Ma)", ylab = "No. specimens", cex=0.8)
# plot time slices as shaded area, this will have to be expanded upon if more time bins are added
polygon (c(358.9, 323.2, 323.2, 358.9), y = c(-1000, -1000, 3000, 3000), border = NA, col = rgb (0, 0, 0, 0.06))
polygon (c(298.9, 273.01, 273.01, 298.9), y = c(-1000, -1000, 3000, 3000), border = NA, col = rgb (0, 0, 0, 0.06))
polygon (c(259.51, 251.902,251.902, 259.51), y = c(-1000, -1000, 3000, 3000), border = NA, col = rgb (0, 0, 0, 0.06))

abline(v=251.9)
abline(v=358.9)

lines (midpoints, y = bin_alphadiversity, lwd=2)

#Amniotes vs. non-amniotes (change H1 (base) to H2, H3 or H4)
group_data$Amniote <- read.table("occ_group_amniote_h1.txt", row.names = 1, header = TRUE)

bin_PA_df <- as.data.frame(bin_PA, stringsAsFactors = FALSE)
bin_PA_df$Amniote <- group_data$Amniote

bin_PA_amniote <- bin_PA_df %>% filter(Amniote != "Non-amniote")    
bin_PA_amniote <- bin_PA_amniote[,-6]   
bin_amniote <- colSums(bin_PA_amniote)

bin_PA_anamniote <- bin_PA_df %>% filter(Amniote != "Amniote")    
bin_PA_anamniote <- bin_PA_anamniote[,-6]   
bin_anamniote <- colSums(bin_PA_anamniote)

lines (midpoints, y = bin_amniote, lwd = 0.5)
lines (midpoints, y = bin_anamniote, lwd = 0.5, lty = 2)

#Partial disparity

partial.disparity <- function(X,groups){ #Partial disparity (as fraction)
  centroid <- colMeans(X)
  pd <- as.matrix(dist(rbind(X,centroid)))[1:nrow(X),-(1:ncol(X))]^2 / (nrow(X)-1)
  sapply(split(pd,groups),sum)
}

partial.disparity.as.percentage <- function(X,groups){ #Partial disparity (as percentage)
  centroid <- colMeans(X)
  pd <- as.matrix(dist(rbind(X,centroid)))[1:nrow(X),-(1:ncol(X))]^2 / (nrow(X)-1)
  sapply(split(pd,groups),sum)*100/sum(pd)
}

#Change H1 (base) to H2, H3 or H4
ages <- read.table("taxon_ages_occlusal.txt",sep="\t",head=TRUE) 
epoch <- read.table("bin_ranges_series.txt",sep="\t",head=TRUE)
group_data <- read.table("occ_group_synsaur_h4.txt", row.names=1, header=T)
pca_scores$Clade <- as.factor(group_data[,1])
pd_through_t <- matrix(NA,nrow=nlevels(pca_scores$Clade),ncol=nrow(epoch)) #Clade partial disparity per time bin
pd_through_t_perc <- matrix(NA,nrow=nlevels(pca_scores$Clade),ncol=nrow(epoch))

rownames(pd_through_t) <- rownames(pd_through_t_perc) <- levels(pca_scores$Clade)
colnames(pd_through_t) <- colnames(pd_through_t_perc) <- epoch[,1]

for(i in seq_along(epoch$Stage)){
  pca_scores_stage <- pca_scores[ages$FAD>=epoch$min.age[i]&ages$LAD<=epoch$max.age[i],] #Take any species that overlaps with the stage
  pca_stage <- prcomp(pca_scores_stage[,1:40],scale. = T) #do a PCA just on those
  pd_through_t_perc[,i] <- partial.disparity.as.percentage(pca_stage$x,pca_scores_stage$Clade)
}

pd_through_t_perc

stratplot <- function(xlim){
  load("ics2023.Rdata")
  plot(NA,xaxs="i",yaxs="i",xlim=xlim,ylim=c(0,3),ax=FALSE,ann=FALSE)
  period <- ics[ics$Type=="Period",]
  for(i in 1:nrow(period)){
    rect(period$Start[i]/1e6,0,period$End[i]/1e6,1,col=period$Color[i])
    text((period$Start[i]/1e6+period$End[i]/1e6)/2,.5,period$Name[i])
  }
  stage <- ics[ics$Type=="Stage",]
  stage$Name <- gsub(" .+$","",stage$Name)
  for(i in 1:nrow(stage)){
    rect(stage$Start[i]/1e6,1,stage$End[i]/1e6,3,col=stage$Color[i])
    text((stage$Start[i]/1e6+stage$End[i]/1e6)/2,2,stage$Name[i],cex=1,srt=90)
  }
  box(lwd=1.5)
  axis(1,cex.axis=0.7,at=seq(0,350,1),labels=FALSE)
  axis(1,cex.axis=0.7,at=seq(0,350,5),labels=FALSE,lwd=1.5)
  axis(1,cex.axis=1,at=seq(0,350,10),lwd=1.5)
  mtext("Age (Ma)",1,2.5,cex=1)
}

#Plots

cols <- c('lightgoldenrod','chartreuse','deepskyblue')

layout(matrix(1:2,ncol=1),height=c(2,1))
par(mar=c(0,5,1,5))
plot(NA,xlim=c(346.7,252.2),ylim=c(0,100),xaxs="i",yaxs="i",ann=FALSE,ax=FALSE)
pl <- cbind(c(100,0,0,0,0),pd_through_t_perc,pd_through_t_perc[,ncol(pd_through_t_perc)])
midp <- c(346.7,apply(epoch[,2:3],1,mean),252.2)
pl <- apply(pl,2,cumsum)
for(i in 1:nrow(pl)){
  if(i==1){
    polygon(c(midp,252.2,346.7),c(pl[i,],0,0),col=cols[i])
  }else{
    polygon(c(midp,rev(midp)),c(pl[i,],rev(pl[i-1,])),col=cols[i])
  }
}
axis(2,at=c(0,25,50,75,100),labels=c("0","0.25","0.5","0.75","1"),las=2)
box(lwd=2)

par(mar=c(5,5,0,5))
stratplot(xlim=c(346.7,252.2))